<?php $__env->startSection('content'); ?>
    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Car Listings</h5>
                
                <a href="<?php echo e(route('car.create')); ?>" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Views">
                    <div
                        class="d-flex align-items-center theme-icons shadow-sm  cursor-pointer rounded btn btn-outline-primary">
                        <div class="font-16"> <i class="fadeIn animated bx bx-plus"></i>
                        </div>
                        <div class="ms-2">Create</div>
                    </div>
                </a>
            </div>


            <div class="card">
                
                <div class="card-body">
                    <div class="product-grid">
                        <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-5 g-3">
                            <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col">
                                    <div class="card border shadow-none mb-0">
                                        <div class="card-body text-center">
                                            <?php if($car->image): ?>
                                                <img style="max-width: 200px; max-height: 100px;overflow: hidden;"
                                                 src="<?php echo e(asset($car->image)); ?>" alt="<?php echo e($car->name); ?>">
                                            <?php endif; ?>
                                            <h6 class="product-title"><?php echo e($car->name); ?></h6>
                                            <p class="product-price fs-5 mb-1"><span>$<?php echo e($car->price); ?></span></p>

                                            <div
                                                class="actions d-flex align-items-center justify-content-center gap-2 mt-3">
                                                <a href="<?php echo e(route('car.edit' , $car->id)); ?>" class="btn btn-sm btn-outline-primary"><i
                                                        class="bi bi-pencil-fill"></i> Edit</a>
                                                
                                                        <form action="<?php echo e(route('car.destroy', $car->id)); ?>" method="POST"
                                                            style="display: inline;">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button type="submit" class="btn   btn-outline-light  "
                                                                onclick="return confirm('Are you sure you want to delete this car?');">
                                                                <div
                                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                                </div>
                                                            </button>
                                                        </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div><!--end row-->
                    </div>

                    

                     <!-- Pagination Links  chatgpt-->
                     <div class="container">


                        <!-- Custom Pagination Links -->
                        <nav class="float-end mt-4" aria-label="Page navigation">
                            <ul class="pagination">
                                
                                <?php if($cars->onFirstPage()): ?>
                                    <li class="page-item disabled"><span class="page-link">Previous</span></li>
                                <?php else: ?>
                                    <li class="page-item"><a class="page-link" href="<?php echo e($cars->previousPageUrl()); ?>">Previous</a></li>
                                <?php endif; ?>

                                
                                <?php $__currentLoopData = $cars->getUrlRange(1, $cars->lastPage()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($page == $cars->currentPage()): ?>
                                        <li class="page-item active"><span class="page-link"><?php echo e($page); ?></span></li>
                                    <?php else: ?>
                                        <li class="page-item"><a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a></li>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <?php if($cars->hasMorePages()): ?>
                                    <li class="page-item"><a class="page-link" href="<?php echo e($cars->nextPageUrl()); ?>">Next</a></li>
                                <?php else: ?>
                                    <li class="page-item disabled"><span class="page-link">Next</span></li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                    </div>

                </div>
            </div>


        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('my.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH G:\xampp\htdocs\2024\07\carproject\resources\views/my/admin/car/index.blade.php ENDPATH**/ ?>