<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>

    <!-- hero section start  -->
    <section id="hero" class=" position-relative overflow-hidden">
        <div class="pattern-overlay pattern-right position-absolute">
            <img src="<?php echo e(asset('assets/images/hero-pattern-right.png')); ?>" alt="pattern">
        </div>
        <div class="pattern-overlay pattern-left position-absolute">
            <img src="<?php echo e(asset('assets/images/hero-pattern-left.png')); ?>" alt="pattern">
        </div>
        <div class="hero-content container text-center">
            <div class="row">
                <div class="detail mb-4">
                    <h1 class="">Find your <span class="text-primary"> rental car </span> </h1>
                    <p class="hero-paragraph">We have many best rental car collections.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- search section start  -->
    

    <section id="search">
        <div class="container search-block p-5">
            <form class="row" method="GET" action="<?php echo e(route('search')); ?>">
                <div class="col-12 mt-4 mt-lg-0">
                    <label for="vehicle" class="label-style text-capitalize form-label">All Available Vehicle </label>
                    <div class="input-group date">
                        <select class="form-select form-control p-3" aria-label="Default select example" name="name">
                            <option selected>Select Vehicle Type</option>
                            <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role->name); ?>">
                                    <?php echo e($role->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <span class="search-icon-position position-absolute p-3">
                            <iconify-icon class="search-icons" icon="solar:bus-outline"></iconify-icon>
                        </span>
                    </div>
                </div>

                <div class="d-grid gap-2 mt-4">
                    <button class="btn btn-primary" type="submit">Find your car</button>
                </div>
            </form>
        </div>
    </section>


    <!-- process section start  -->
    <section id="process">
        <div class=" process-content container">
            <h2 class=" text-center my-5 pb-5">Our renting <span class="text-primary"> process </span> </h2>
            <hr class="progress-line">
            <div class="row process-block">
                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Choose a vehicle </h5>
                    <p>Sed euismod mauris corper libero.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Pick location & date </h5>
                    <p>Nisi maecenas fermentum neque.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Book your car </h5>
                    <p>Mauris corper accumsan urna sed.</p>
                </div>

                <div class="col-6 col-lg-3 text-start my-4">
                    <div class="bullet"></div>
                    <h5 class="text-uppercase mt-5"> Finish process </h5>
                    <p>Orci duis ut lectus metus nam sette.</p>
                </div>

            </div>


        </div>
    </section>

    <!-- rental section start  -->
    <!-- rental section start  -->
    <section id="cars" class="my-5 py-5">
        <div class="container">
            <div class="row">
                <?php $__currentLoopData = $cars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $car): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 my-4">
                        <div class="card">
                            <a href="<?php echo e(route('single-car', $car->id)); ?>">
                                <img src="<?php echo e(asset($car->image)); ?>" height="200px" alt="<?php echo e($car->name); ?>" class="card-img-top">
                            </a>
                            <div class="card-body p-4">
                                <a href="<?php echo e(route('single-car', $car->id)); ?>">
                                    <h4 class="card-title"><?php echo e($car->name); ?></h4>
                                </a>
                                <div class="card-text ">
                                    <ul class="d-flex list-unstyled">
                                        
                                        <li class="rental-list display-small"> <?php echo e(Str::ucfirst($car->fuel_type)); ?></li>
                                    </ul>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <h4 class="pt-2">$ <?php echo e($car->price); ?><span class="rental-price">/day</span>
                                    </h4>
                                    <a href="<?php echo e(route('single-car', $car->id)); ?>" class="btn btn-primary">Book now
                                    </a>
                                </div>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <nav aria-label="Page navigation" class="d-flex justify-content-center mt-5">
                <ul class="pagination">
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Previous">
                            <iconify-icon icon="solar:arrow-left-linear" class="pagination-arrow"></iconify-icon>
                        </a>
                    </li>
                    <li class="page-item active" aria-current="page"><a class="page-link" href="#">1</a>
                    </li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item"><a class="page-link" href="#">3</a></li>
                    <li class="page-item"><a class="page-link" href="#">4</a></li>
                    <li class="page-item"><a class="page-link" href="#">5</a></li>
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Next">
                            <iconify-icon icon="solar:arrow-right-linear" class="pagination-arrow"></iconify-icon>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </section>

    

    <!-- services section start  -->
    <section id="services">

        <div class="container  py-5 my-5">
            <div class="row py-5 ">
                <div class=" pb-5  col-10 col-sm-8 col-lg-6">
                    <h2 class="">See <span class="text-primary">best services</span> for your solution </h2>
                </div>
                <div class=" pb-5  col-lg-6">
                    <p class="pt-4">Vitae aliquam vestibulum elit adipiscing massa diam in dignissim. Risus tellus
                        libero elementum aliquam etiam. Lectus adipiscing est auctor mi quisque nunc non vive adipiscing
                        massa diam in digniss imrra est. </p>
                </div>
            </div>

        </div>

    </section>

    <section id="service-2">
        <div class=" services-sub container mb-5 pb-5">
            <div class="row">
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:shield-check-outline"></iconify-icon>
                        <h5>Secured Payment</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:bookmark-opened-outline"></iconify-icon>
                        <h5>any class vehicle</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:user-circle-outline"></iconify-icon>
                        <h5>Car sharing options</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>
                <div class=" mt-4 col-6 col-lg-3">
                    <div class="services-components text-center pt-4 pb-3">
                        <iconify-icon class="services-icon my-2" icon="solar:call-chat-outline"></iconify-icon>
                        <h5>Help center & Support</h5>
                        <p>Aliquam etiam lectus adipiscing est auctor mi quisque non.</p>
                    </div>
                </div>

            </div>
        </div>

    </section>

    <!-- faq section start  -->
    <section id="faq">

        <div class="container my-5 py-5 ">
            <h2 class=" text-center my-5">We’ve got <span class="text-primary"> answers</span> </h2>


            <div class="accordion col-md-8 offset-md-2" id="accordionPanelsStayOpenExample">

                <div class="accordion-item mt-3">
                    <h5 class="accordion-header" id="panelsStayOpen-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                            aria-controls="panelsStayOpen-collapseOne">
                            Why to believe with GoCar Car rental service ?
                        </button>
                    </h5>
                    <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a.
                                Tristique ultricies consectetu at.</p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="accordion-item mt-3">
                    <h2 class="accordion-header" id="panelsStayOpen-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseTwo" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseTwo">
                            How to know which renting price price is best?
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseTwo" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingTwo">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus
                                nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a. Tristique
                                ultricies consectetu
                                at.</p>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="accordion-item mt-3">
                    <h2 class="accordion-header" id="panelsStayOpen-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#panelsStayOpen-collapseThree" aria-expanded="false"
                            aria-controls="panelsStayOpen-collapseThree">
                            What are the special features of gocar?
                        </button>
                    </h2>
                    <div id="panelsStayOpen-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="panelsStayOpen-headingThree">
                        <div class="accordion-body">
                            <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in aliquet tincidunt
                                nam lectus
                                nec. Placerat interdum auctor facilisi massa laoreet hendrerit posuere a. Tristique
                                ultricies consectetu
                                at.</p>
                        </div>
                    </div>
                </div>
                <hr>




            </div>

        </div>
    </section>



    <!-- call-to-action section start  -->
    <section id="action" class="position-relative">

        <div class="pattern-overlay pattern-right position-absolute">
            <img src="<?php echo e(asset('assets/images/call-to-action-pattern.png')); ?>" alt="pattern">
        </div>

        <div class="container  py-5 my-5">
            <div class="row py-5 ">
                <div class=" col-10 col-sm-8 col-lg-6">
                    <h2 class="">Let’s begin with <span class="text-primary">GoCar rental.</span> </h2>
                </div>
                <div class=" col-lg-6">
                    <p>Neque, vestibulum sed varius magna et at. Eu, adipiscing morbi augue justo. Nibh laoreet volutpat
                        quis velit. Blandit aliquam donec sed morbi congue eget lorem viverra porta id lobortis.</p>
                    <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary mt-2">Contact us </a>
                </div>
            </div>

        </div>

    </section>



 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH G:\xampp\htdocs\2024\07\carproject\resources\views/dashboard.blade.php ENDPATH**/ ?>