<?php

use App\Http\Controllers\Admin\BookingController;
use App\Http\Controllers\Admin\CarController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FaqController;
use App\Http\Controllers\Admin\FeedbackController;
use App\Http\Controllers\Admin\MessageController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\FrontEnd\AllController;
use App\Http\Controllers\FrontEnd\ContactController;
use App\Http\Controllers\FrontEnd\FeedbackController as FrontEndFeedbackController;
use App\Http\Controllers\FrontEnd\PageController;
use App\Http\Controllers\FrontEnd\PaymentController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\SearchController;
use App\Models\Car;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Route;

// guest
Route::get('/', function () {
    $cars = Car::all();
    return view('welcome', ['cars' => $cars]);
});

// user and guest
Route::get('/search', [SearchController::class , 'search'])->name('search');


// auth user
Route::middleware(['auth' , 'user'])->group(function () {
    Route::get('/dashboard', [PageController::class , 'dashboard'])->name('dashboard');
    Route::get('/faq', [PageController::class , 'faq'])->name('faq');
    Route::get('/service', [PageController::class , 'service'])->name('service');
    Route::get('/about', [PageController::class , 'about'])->name('about');
    Route::get('/review', [PageController::class , 'review'])->name('review');
    Route::get('/team', [PageController::class , 'team'])->name('team');
    Route::get('/car', [PageController::class , 'cars'])->name('cars');
    Route::get('/car/{id}/show', [PageController::class , 'car'])->name('single-car');
    Route::get('/status/{id}', [PageController::class , 'status'])->name('status');

    Route::get('/contact', [PageController::class , 'contact'])->name('contact');
    Route::post('/contact' , [ContactController::class , 'store'])->name('contact.save');
    Route::post('/rent', [AllController::class , 'booking'])->name('booking.create');


    Route::get('/feedback', [FrontEndFeedbackController::class , 'create'])->name('feedbacks');
    Route::post('/feedback' , [FrontEndFeedbackController::class , 'store'])->name('feedbacks.save');

    // Route::resource('feedback' , FeedbackController::class)->only(['create' , 'store' ]); //also known as feedback

});

// auth user profile
Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});



// admin panel
Route::middleware(['auth','role'])->prefix('admin')->group(function () {
    // Route::get('dashboard', function () {

    //     return view('my.admin.dashboard');
    // })->name('admin.dashboard');


    Route::get('dashboard', [DashboardController::class , 'dashboard'])->name('admin.dashboard');
    Route::resource('car', CarController::class);
    Route::resource('user', UserController::class);
    Route::resource('rent' , BookingController::class )->only(['index' , 'edit' , 'update','destroy']);
    Route::resource('message' , MessageController::class)->only(['index' , 'show' , 'destroy']); //also known as feedback
    Route::resource('feedback' , FeedbackController::class)->only(['index' , 'show' ,'update', 'destroy']); //also known as feedback
    Route::resource('faqs' , FaqController::class);
});

//paypal
Route::get('payment-status', array('as' => 'paywithpaypal', 'uses' => [PaypalController::class, 'payWithPaypal']));
Route::get('payment', [PaymentController::class, 'postPaymentWithpaypal']);
Route::get('success', [PaymentController::class, 'success'])->name('success');
Route::get('cancel', [PaymentController::class, 'cancel'])->name('cancel');



Route::get('/fresh', function () {
    Artisan::call('migrate:fresh');
    $output = Artisan::output();
    return $output;
});
Route::get('/seed', function () {
    Artisan::call('db:seed');
    $output = Artisan::output();
    return $output;
});

Route::get('/list', function () {
    Artisan::call('route:list');
    $output = Artisan::output();
    return $output;
});


require __DIR__ . '/auth.php';
