<x-app-layout>

    <section class="faqs-wrap no-padding-bottom">
        <div class="container mt-5">
            <div class="row g-5 my-4">
                <main class="col-md-8">
                    <h3 class="section-title text-uppercase">Frequently asked questions</h3>
                    <p>Malesuada nunc vel risus commodo viverra. Viverra accumsan in nisl nisi. Pretium nibh ipsum
                        consequat
                        nisl
                        vel pretium. Tortor dignissim convallis aenean et tortor at risus viverra adipiscing.</p>
                    <div class="page-content my-5">

                        <div class="accordion" id="accordionPanelsStayOpenExample">


                            @foreach ($faqs as $faq)
                                <div class="accordion-item mt-3">
                                    <h2 class="accordion-header" id="panelsStayOpen-heading{{$faq->id}}">
                                        <button class="accordion-button {{$faqs[0]['id'] == $faq->id ? '' : 'collapsed'}} " type="button"
                                            data-bs-toggle="collapse" data-bs-target="#panelsStayOpen-collapse{{$faq->id}}"
                                            aria-expanded="false" aria-controls="panelsStayOpen-collapse{{$faq->id}}">
                                            {{ $faq->subject }}
                                        </button>
                                    </h2>
                                    <div id="panelsStayOpen-collapse{{$faq->id}}" class="accordion-collapse collapse {{$faqs[0]['id'] == $faq->id ? 'show' : ''}}"
                                        aria-labelledby="panelsStayOpen-heading{{$faq->id}}">
                                        <div class="accordion-body">
                                            <p>{{ $faq->comment }}</p>
                                        </div>
                                    </div>
                                </div>
                                <hr>


                                {{-- <div class="accordion-item mt-3">
                                <h5 class="accordion-header" id="panelsStayOpen-headingOne">
                                    <button class="accordion-button " type="button" data-bs-toggle="collapse"
                                        data-bs-target="#panelsStayOpen-collapseOne" aria-expanded="true"
                                        aria-controls="panelsStayOpen-collapseOne">
                                        Why to believe with GoCar Car rental service ?
                                    </button>
                                </h5>
                                <div id="panelsStayOpen-collapseOne" class="accordion-collapse collapse show">
                                    <div class="accordion-body">
                                        <p>Diam orci gravida convallis at enim risus viverra. Hac mi tristique in
                                            aliquet tincidunt
                                            nam lectus nec. Placerat interdum auctor facilisi massa laoreet hendrerit
                                            posuere a.
                                            Tristique ultricies consectetu at.</p>
                                    </div>
                                </div>
                            </div>
                            <hr> --}}
                            @endforeach
                        </div>

                    </div>
                </main>
                <div class="inquiry-item col-md-4">
                    <h3 class="section-title mb-3">Ask us anything</h3>
                    <p>Call Us +123 987 456 or just drop us your message at <a
                            href="mailto:contact@yourcompany.com">contact@yourcompany.com</a>. You can directly message
                        us. </p>
                    <form id="form" class="form-group flex-wrap"
                        action="{{ route('feedbacks.save', ['page' => 'faq']) }}" method="POST">
                        @csrf
                        <div class="form-input col-lg-12 d-flex mb-3">
                            <input type="text" name="name" value="{{ Auth::user()->name }}"
                                placeholder="Write Your Name Here" class="form-control ps-3 me-3">
                            <input type="text" name="email" value="{{ Auth::user()->email }}"
                                placeholder="Write Your Email Here" class="form-control ps-3">
                        </div>
                        <div class="col-lg-12 mb-3">
                            <input type="text" name="email" placeholder="Phone Number"
                                value="{{ Auth::user()->phone_number }}" class="form-control ps-3">
                        </div>
                        {{-- <div class="col-lg-12 mb-3">
                            <input type="text" name="email" placeholder="Write Your Subject Here"
                                class="form-control ps-3">
                        </div> --}}
                        <div class="col-lg-12 mb-3">
                            <textarea placeholder="Write Your Message Here" class="form-control ps-3" name="subject" rows="8"></textarea>
                        </div>
                        @error('subject')
                            <p class="text-danger">{{ $message }}</p>
                        @enderror
                        <div class="d-grid">
                            <button class="btn btn-primary btn-lg text-uppercase btn-rounded-none">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>





</x-app-layout>
