@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Customer Details</h5>

                <a href="{{ route('user.create') }}" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Views">
                    <div
                        class="d-flex align-items-center theme-icons shadow-sm  cursor-pointer rounded btn btn-outline-primary">
                        <div class="font-16"> <i class="fadeIn animated bx bx-plus"></i>
                        </div>
                        <div class="ms-2">Create</div>
                    </div>
                </a>
            </div>
            <div class="table-responsive mt-3">
                <table class="table align-middle">
                    <thead class="table-secondary">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Gender</th>
                            <th>Phone Number</th>
                            {{-- <th>Actions</th> --}}
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $user)
                            <tr>
                                <td>{{ $user->id }}</td>
                                <td>
                                    <div class="d-flex align-items-center gap-3 cursor-pointer">
                                        <img src="{{ asset('assets/assets/images/avatars/avatar-1.png') }}"
                                            class="rounded-circle" width="44" height="44" alt="">
                                        <div class="">
                                            <p class="mb-0">{{ $user->name }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td>{{ $user->email }}</td>
                                <td>{{ $user->gender }}</td>
                                <td>{{ $user->phone_number }}</td>




                                {{-- <td>
                                    <div class="table-actions d-flex align-items-center gap-3 fs-6">
                                        <a href="{{ route('user.show', $user->id) }}" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" aria-label="Edit">
                                            <div
                                                class="d-flex align-items-center px-2 cursor-pointer rounded  btn-outline-primary font-30">
                                                <i class=" fadeIn animated bx bx-show-alt"></i>
                                            </div>
                                        </a>


                                        <a href="{{ route('user.edit', $user->id) }}" data-bs-toggle="tooltip"
                                            data-bs-placement="bottom" aria-label="Edit">
                                            <div
                                                class="d-flex align-items-center px-2 cursor-pointer rounded  btn-outline-warning font-30">
                                                <i class=" fadeIn animated bx bx-edit"></i>
                                            </div>
                                        </a>



                                        <form action="{{ route('user.destroy', $user->id) }}" method="POST"
                                            style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn   btn-outline-light  "
                                                onclick="return confirm('Are you sure you want to delete this user?');">
                                                <div
                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                </div>
                                            </button>
                                        </form>
                                    </div>
                                </td> --}}
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>


        </div>
    </div>
@endsection
