@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif



    <div class="card">
        <div class="card-body">
            <div class="d-flex align-items-center">
                <img src="{{ asset('assets/assets/images/avatars/avatar-1.png') }}" alt="" class="rounded-circle"
                    width="52" height="52">
                <div class="ms-3 flex-grow-1">
                    <h6 class="mb-0 dropdown-msg-user">{{ $message->user->name }}
                        <span class="msg-time float-end text-secondary">
                            <form action="{{ route('message.destroy', $message->id) }}" method="POST"
                                style="display: inline;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn   btn-outline-light  "
                                    onclick="return confirm('Are you sure you want to delete this message?');">
                                    <div
                                        class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                        <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                    </div>
                                </button>
                            </form>
                        </span>
                    </h6>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="email-read-content px-md-5 py-5">
                {{ $message->message }}
            </div>
        </div>

    </div>
@endsection
