@extends('my.admin.layouts.master')

@section('content')
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif
    <div class="card">
        <div class="card-body">
            <div class="d-flex justify-content-between">
                <h5 class="mb-0">Car Listings</h5>
                {{-- <form class="ms-auto position-relative">
                    <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i class="bi bi-search"></i>
                    </div>
                    <input class="form-control ps-5" type="text" placeholder="search">
                </form> --}}
                <a href="{{ route('car.create') }}" data-bs-toggle="tooltip" data-bs-placement="bottom" aria-label="Views">
                    <div
                        class="d-flex align-items-center theme-icons shadow-sm  cursor-pointer rounded btn btn-outline-primary">
                        <div class="font-16"> <i class="fadeIn animated bx bx-plus"></i>
                        </div>
                        <div class="ms-2">Create</div>
                    </div>
                </a>
            </div>


            <div class="card">
                {{-- <div class="card-header py-3">
                    <div class="row g-3 align-items-center">
                        <div class="col-lg-3 col-md-6 me-auto">
                            <div class="ms-auto position-relative">
                                <div class="position-absolute top-50 translate-middle-y search-icon px-3"><i
                                        class="bi bi-search"></i></div>
                                <input class="form-control ps-5" type="text" placeholder="search produts">
                            </div>
                        </div>
                        <div class="col-lg-2 col-6 col-md-3">
                            <select class="form-select">
                                <option>All category</option>
                                <option>Fashion</option>
                                <option>Electronics</option>
                                <option>Furniture</option>
                                <option>Sports</option>
                            </select>
                        </div>
                        <div class="col-lg-2 col-6 col-md-3">
                            <select class="form-select">
                                <option>Latest added</option>
                                <option>Cheap first</option>
                                <option>Most viewed</option>
                            </select>
                        </div>
                    </div>
                </div> --}}
                <div class="card-body">
                    <div class="product-grid">
                        <div class="row row-cols-1 row-cols-lg-4 row-cols-xl-4 row-cols-xxl-5 g-3">
                            @foreach ($cars as $car)
                                <div class="col">
                                    <div class="card border shadow-none mb-0">
                                        <div class="card-body text-center">
                                            @if ($car->image)
                                                <img style="max-width: 200px; max-height: 100px;overflow: hidden;"
                                                 src="{{ asset($car->image) }}" alt="{{ $car->name }}">
                                            @endif
                                            <h6 class="product-title">{{ $car->name }}</h6>
                                            <p class="product-price fs-5 mb-1"><span>${{ $car->price }}</span></p>

                                            <div
                                                class="actions d-flex align-items-center justify-content-center gap-2 mt-3">
                                                <a href="{{route('car.edit' , $car->id)}}" class="btn btn-sm btn-outline-primary"><i
                                                        class="bi bi-pencil-fill"></i> Edit</a>
                                                {{-- <a href="javascript:;" class="btn btn-sm btn-outline-danger"><i
                                                        class="bi bi-trash-fill"></i> Delete</a> --}}
                                                        <form action="{{ route('car.destroy', $car->id) }}" method="POST"
                                                            style="display: inline;">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn   btn-outline-light  "
                                                                onclick="return confirm('Are you sure you want to delete this car?');">
                                                                <div
                                                                    class="d-flex align-items-center font-24 cursor-pointer rounded   btn-outline-danger">
                                                                    <i class="fadeIn animated bx bx-trash px-2 py-4"></i>
                                                                </div>
                                                            </button>
                                                        </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div><!--end row-->
                    </div>

                    {{-- <nav class="float-end mt-4" aria-label="Page navigation">
                        <ul class="pagination">
                            <li class="page-item disabled"><a class="page-link" href="#">Previous</a></li>
                            <li class="page-item active"><a class="page-link" href="#">1</a></li>
                            <li class="page-item"><a class="page-link" href="#">2</a></li>
                            <li class="page-item"><a class="page-link" href="#">3</a></li>
                            <li class="page-item"><a class="page-link" href="#">Next</a></li>
                        </ul>
                    </nav> --}}

                     <!-- Pagination Links  chatgpt-->
                     <div class="container">


                        <!-- Custom Pagination Links -->
                        <nav class="float-end mt-4" aria-label="Page navigation">
                            <ul class="pagination">
                                {{-- Previous Page Link --}}
                                @if ($cars->onFirstPage())
                                    <li class="page-item disabled"><span class="page-link">Previous</span></li>
                                @else
                                    <li class="page-item"><a class="page-link" href="{{ $cars->previousPageUrl() }}">Previous</a></li>
                                @endif

                                {{-- Pagination Elements --}}
                                @foreach ($cars->getUrlRange(1, $cars->lastPage()) as $page => $url)
                                    @if ($page == $cars->currentPage())
                                        <li class="page-item active"><span class="page-link">{{ $page }}</span></li>
                                    @else
                                        <li class="page-item"><a class="page-link" href="{{ $url }}">{{ $page }}</a></li>
                                    @endif
                                @endforeach

                                {{-- Next Page Link --}}
                                @if ($cars->hasMorePages())
                                    <li class="page-item"><a class="page-link" href="{{ $cars->nextPageUrl() }}">Next</a></li>
                                @else
                                    <li class="page-item disabled"><span class="page-link">Next</span></li>
                                @endif
                            </ul>
                        </nav>
                    </div>

                </div>
            </div>


        </div>
    </div>
@endsection
