<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {


        Schema::create('bookings', function (Blueprint $table) {
            $table->id('id');
            $table->unsignedBigInteger('car_id');
            $table->unsignedBigInteger('user_id'); // Adding user_id field
            $table->string('book_place');
            $table->string('destination');
            $table->dateTime('book_date');
            $table->dateTime('return_date');
            $table->string('book_status');
            // $table->integer('duration');
            // $table->decimal('price', 8, 2);
            $table->timestamps();

            // Foreign key constraints
            $table->foreign('car_id')->references('id')->on('cars')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
