<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\File;
/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Car>
 */
class CarFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {

        $imageDirectory = public_path('assets/assets/images/car');
        $images = File::files($imageDirectory);
        $randomImage = $images[array_rand($images)];
        $imageName = 'assets/assets/images/car/' . basename($randomImage);

        return [
            'name' => $this->faker->word,
            'fuel_type' => $this->faker->randomElement(['Petrol', 'Diesel', 'Electric', 'Hybrid']),
            'capacity' => $this->faker->numberBetween(2, 8),
            'price' => $this->faker->numberBetween(10000, 100000),
            'image' => $imageName,
            'status' => $this->faker->randomElement(['yes', 'no']),
        ];
    }
}
