<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'car_id',
        'user_id',
        'book_place',
        'book_date',
        'duration',
        'destination',
        'return_date',
        'price',
        'book_status',
    ];

    public function car()
    {
        return $this->belongsTo(Car::class);
    }

    // Define the relationship with User
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Accessor for formatted book_date
    public function getFormattedBookDateAttribute()
    {
        return Carbon::parse($this->book_date)->format('j F  Y');
    }

    // Accessor for formatted return_date
    public function getFormattedReturnDateAttribute()
    {
        return Carbon::parse($this->return_date)->format('j F Y');
    }

    // Accessor for duration in days
    public function getDurationInDaysAttribute()
    {
        $bookDate = Carbon::parse($this->book_date);
        $returnDate = Carbon::parse($this->return_date);

        return $bookDate->diffInDays($returnDate);
    }

    public function payment()
    {
        return $this->hasOne(Payment::class);
    }
}
