<?php

namespace App\Http\Controllers;

use App\Models\Car;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    public function search(Request $request)
    {
        $query = Car::query();
        // dd($query);

        if ($request->filled('name')) {
            $query->where('name', $request->input('name'));
        }

        // if ($request->filled('price')) {
        //     $query->where('price', '<=', $request->input('price'));
        // }

        // if ($request->filled('fuel_type')) {
        //     $query->where('fuel_type', $request->input('fuel_type'));
        // }

        // if ($request->filled('capacity')) {
        //     $query->where('capacity', '>=', $request->input('capacity'));
        // }

        $cars = $query->get();
        if(auth()->user()){
            return view('my.authuser.car', compact('cars'));
        }
        return view('welcome', compact('cars'));
    }
}

