<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use App\Mail\BookingNotification;
use App\Models\Booking;
use App\Models\Payment;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Srmklive\PayPal\Services\PayPal as PayPalService;
use Session;


class PaymentController extends Controller
{
    public function postPaymentWithpaypal()
    {
        // Create a PayPal instance
        $provider = new PayPalService;
        $provider = \PayPal::setProvider();
        $provider->getAccessToken();
        // Set the payment amount
        $data = [
            "intent" => "CAPTURE",
            "purchase_units" => [
                [
                    "amount" => [
                        "currency_code" => "USD",
                        "value" => "100.00",
                    ],
                ],
            ],
            "payment_source" => [
                "paypal" => [
                    "experience_context" => [
                        "payment_method_preference" => "IMMEDIATE_PAYMENT_REQUIRED",
                        "user_action" => "PAY_NOW",
                        "return_url" => route('success'),
                        "cancel_url" => route('cancel'),
                    ],
                ],
            ],
        ];


        $order = $provider->createOrder($data);
        dd($order);
    }

    public function success(Request $request)
    {
        // dd($request->get('token'));
        // Get the payment details from the PayPal response
        $paymentId = $request->get('token');
        $provider = new PayPalService;
        $provider = \PayPal::setProvider();
        $provider->getAccessToken();
        $order = $provider->showOrderDetails($paymentId);
        // dd($order); // status approved
        if ($order['status'] === 'APPROVED') {
                   $capture = $provider->capturePaymentOrder($paymentId);

        if ($capture['status'] === 'COMPLETED') {
            $payment = Payment::where('paypal_id', $paymentId)->first();
            $booking = Booking::find($payment->booking->id);
            $payment->status = $capture['status'];
            $payment->save();

            $admin = User::where('role', 'admin')->first();
            $email = $admin->email;
            Mail::to($email)->send(new BookingNotification($booking));

            \Session::put('success', 'Booking confirmed, Soon you will be contacted by our team, thanks!');
            return view('my.authuser.complete');
        }
    }


        // elseif ($order['status'] === 'PAYER_ACTION_REQUIRED') {
        //     return redirect()->route('payment.payer_action', ['paymentId' => $paymentId]);
        // }

        \Session::put('error', 'An error occurent, Payment failed. !!');
        return view('my.authuser.complete');

        //$payment =
        // Process the payment details here
    }

    public function cancel(Request $request)
    {
        // Handle the payment cancellation here
        // dd($request->get('token'));
        // Handle the payment cancellation here
        Session::flash('error', 'Payment was canceled.');
        return redirect()->back(); // or another appropriate route
    }
}
