<?php

namespace App\Http\Controllers\FrontEnd;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Payment;
use App\Mail\BookingNotification;
use App\Models\Booking;
use Srmklive\PayPal\Services\PayPal as PayPalService;

class AllController extends Controller
{
    //
    public function booking(Request $request)
    {
        // dd($request->all());
        // Validate and create a new booking
        $request->validate([
            'car_id' => 'required|exists:cars,id',
            'user_id' => 'required|exists:users,id', // Validate user_id
            'book_place' => 'required|string',
            'destination' => 'required|string',
            // 'duration' => 'required|integer',
            // 'price' => 'required|numeric',
            'book_date' => 'required|date',
            'return_date' => 'required|date|after:book_date',
            'book_status' => 'required|string',
        ]);

        $booking = Booking::create($request->all());
        // Calculate duration in days between book_date and return_date
        $bookDate = new \DateTime($request->input('book_date'));
        $returnDate = new \DateTime($request->input('return_date'));
        $duration = $returnDate->diff($bookDate)->days;

        // Calculate price based on duration and a rate per day (e.g., $10 per day)
        // $ratePerDay = 10; // Example rate per day
        $price = $duration * $booking->car->price;

        // dd($booking->car->price);

        $provider = new PayPalService;
        $provider = \PayPal::setProvider();
        $provider->getAccessToken();
        // Set the payment amount
        $data = [
            "intent" => "CAPTURE",
            "purchase_units" => [
                [
                    "amount" => [
                        "currency_code" => "USD",
                        "value" => $price,
                    ],
                ],
            ],
            "payment_source" => [
                "paypal" => [
                    "experience_context" => [
                        "payment_method_preference" => "IMMEDIATE_PAYMENT_REQUIRED",
                        "user_action" => "PAY_NOW",
                        "return_url" => route('success'),
                        "cancel_url" => route('cancel'),
                    ],
                ],
            ],
        ];


        $order = $provider->createOrder($data);

        $payment = new Payment();

        $payment->booking_id = $booking->id;
        $payment->paypal_id = $order['id'];
        $payment->status = $order['status'];
        // dd($order['links']['1']['href']);
        $payment->save();
        if ($payment->save()) {
            return redirect($order['links']['1']['href']);
        }
        dd($payment);



        // $booking = Booking::create($request->all());
    }
}
